<?php

namespace App\Http\Controllers\Admin\Location;

use App\Http\Controllers\Controller;
use App\Models\City;
use App\Models\Country;
use App\Models\State;
use Illuminate\Http\Request;

class LocationController extends Controller
{
    public function countries(Request $request)
    {
        $request->validate([
            'search' => 'nullable|string',
        ]);

        return $this->searchModel(Country::query(), $request->search);
    }

    public function states(Request $request)
    {
        $request->validate([
            'country_id' => 'required|exists:countries,id',
            'search' => 'nullable|string',
        ]);

        $query = State::where('country_id', $request->country_id);

        return $this->searchModel($query, $request->search);
    }

    public function cities(Request $request)
    {
        $request->validate([
            'state_id' => 'required|exists:states,id',
            'search' => 'nullable|string',
        ]);

        $query = City::where('state_id', $request->state_id);

        return $this->searchModel($query, $request->search);
    }

    private function searchModel($query, $search)
    {
        if ($search) {
            $query->where('name', 'like', "%{$search}%");
        }

        return $query->paginate(15);
    }
}
